//
//  DHDArtNetIOController.h
//  DHDMX
//
//  Created by Douglas Heriot on 9/02/12.
//  Copyright (c) 2012 Douglas Heriot Design. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "DHDArtNetIOControllerDelegate.h"

@class DHDArtDMXIdentity;
@class DHDMXGCDAsyncUdpSocket;

@interface DHDArtNetIOController : NSObject
{
	DHDMXGCDAsyncUdpSocket *receivingSocket;
	DHDMXGCDAsyncUdpSocket *sendingSocket;
	dispatch_queue_t queue;
	dispatch_queue_t filterQueue;
	
	NSMutableSet *_waitingUniverses;
	BOOL _receiving;
	
	id<DHDArtNetIOControllerDelegate> _delegate;
	
	NSUInteger _droppedPackets;
}

@property (unsafe_unretained) id<DHDArtNetIOControllerDelegate> delegate;
@property (readonly) NSUInteger droppedPackets;

@property (readonly) BOOL receiving;
- (BOOL)beginReceiving:(NSError **)error;

- (void)sendPacket:(DHDArtNetPacket *)packet;

// Convenience methods, for generating and sending a packet
- (void)sendDMX:(NSData *)dmx withArtDMXIdentity:(DHDArtDMXIdentity *)details;
- (void)sendDMX:(NSData *)dmx withArtDMXIdentity:(DHDArtDMXIdentity *)details sequence:(uint8_t)sequence;

// Convenience method to get a shared controller
// However, this is only optional - you're still free to create your own instances
// Shouldn’t touch its delegate - other objects might be using it too!
+ (DHDArtNetIOController *)sharedIOController;

@end
